/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors.client.renderer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.resources.IResourceManager;
import sekelsta.horse_colors.client.renderer.TextureLayer;
import sekelsta.horse_colors.util.Color;

public class TextureLayerGroup
extends TextureLayer {
    public List<TextureLayer> layers;
    boolean isColored = false;

    public TextureLayerGroup() {
        this.layers = new ArrayList<TextureLayer>();
    }

    public TextureLayerGroup(List<TextureLayer> layers) {
        this.layers = layers;
    }

    public void add(TextureLayer layer) {
        this.layers.add(layer);
    }

    @Override
    public NativeImage getLayer(IResourceManager manager) {
        Iterator<TextureLayer> iterator = this.layers.iterator();
        TextureLayer baselayer = iterator.next();
        NativeImage baseimage = baselayer.getLayer(manager);
        if (baseimage == null) {
            return null;
        }
        baselayer.colorLayer(baseimage);
        while (iterator.hasNext()) {
            NativeImage image;
            TextureLayer layer = iterator.next();
            if (layer == null || (image = layer.getLayer(manager)) == null) continue;
            layer.combineLayers(baseimage, image);
        }
        this.colorLayer(baseimage);
        this.isColored = true;
        return baseimage;
    }

    @Override
    public void combineLayers(NativeImage base, NativeImage image) {
        if (this.isColored) {
            Color temp = this.color;
            this.color = new Color();
            super.combineLayers(base, image);
            this.color = temp;
        } else {
            super.combineLayers(base, image);
        }
    }

    @Override
    public String getUniqueName() {
        String s = "";
        for (int i = 0; i < this.layers.size(); ++i) {
            if (this.layers.get(i) == null) continue;
            s = s + this.layers.get(i).getUniqueName();
        }
        return s.toLowerCase(Locale.ENGLISH);
    }

    public List<String> getDebugStrings() {
        ArrayList<String> strings = new ArrayList<String>();
        for (TextureLayer layer : this.layers) {
            if (layer instanceof TextureLayerGroup) {
                TextureLayerGroup group = (TextureLayerGroup)layer;
                for (String s : group.getDebugStrings()) {
                    strings.add("    " + s);
                }
                continue;
            }
            if (layer == null) continue;
            strings.add(layer.toString());
        }
        return strings;
    }
}

